/*
 * Decompiled with CFR 0.152.
 */
package jade.util;

import jade.util.leap.Properties;
import jade.util.leap.Serializable;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;

public class Logger
implements Serializable {
    private static PrintStream logStream = System.out;
    public static final int SEVERE = 10;
    public static final int WARNING = 9;
    public static final int INFO = 8;
    public static final int CONFIG = 7;
    public static final int FINE = 5;
    public static final int FINER = 4;
    public static final int FINEST = 3;
    public static final int ALL = Integer.MIN_VALUE;
    public static final int OFF = Integer.MAX_VALUE;
    private static Properties verbosityLevels = null;
    private static Hashtable loggers = new Hashtable();
    private int myLevel = 8;
    private String myName;

    public static void println(String log) {
        logStream.println(log);
    }

    public static synchronized Logger getMyLogger(String name) {
        Logger l = (Logger)loggers.get(name);
        if (l == null) {
            StringBuffer sb = new StringBuffer(name.replace('.', '_'));
            sb.append("_loglevel");
            String key = sb.toString();
            int level = 8;
            if (verbosityLevels != null) {
                try {
                    level = Logger.getLevel(verbosityLevels.getProperty(key));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            l = new Logger(name, level);
            loggers.put(name, l);
        }
        return l;
    }

    public static void initialize(Properties pp) {
        if (pp != null) {
            PrintStream ps = Logger.initLogStream(pp);
            if (ps != null) {
                logStream = ps;
            }
            verbosityLevels = pp;
        } else {
            verbosityLevels = new Properties();
        }
    }

    private static int getLevel(String level) {
        block11: {
            if (level != null) {
                try {
                    return Integer.parseInt(level);
                }
                catch (Exception e) {
                    if (level.equals("severe")) {
                        return 10;
                    }
                    if (level.equals("warning")) {
                        return 9;
                    }
                    if (level.equals("info")) {
                        return 8;
                    }
                    if (level.equals("config")) {
                        return 7;
                    }
                    if (level.equals("fine")) {
                        return 5;
                    }
                    if (level.equals("finer")) {
                        return 4;
                    }
                    if (level.equals("finest")) {
                        return 3;
                    }
                    if (level.equals("all")) {
                        return Integer.MIN_VALUE;
                    }
                    if (!level.equals("off")) break block11;
                    return Integer.MAX_VALUE;
                }
            }
        }
        return 8;
    }

    private Logger(String name, int level) {
        this.myName = name;
        this.myLevel = level;
    }

    public boolean isLoggable(int level) {
        return level >= this.myLevel;
    }

    public void log(int level, String msg) {
        this.log(level, msg, null);
    }

    public void log(int level, String msg, Throwable t) {
        if (level >= this.myLevel) {
            StringBuffer sb = new StringBuffer(this.myName);
            sb.append(": ");
            sb.append(msg);
            if (t != null) {
                sb.append('[');
                sb.append(t);
                sb.append(']');
            }
            Logger.println(sb.toString());
        }
    }

    private static PrintStream initLogStream(Properties pp) {
        String logprefix = pp.getProperty("jade_util_Logger_logfile");
        if (logprefix != null) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("ddMMyyyy");
                String logfile = logprefix + sdf.format(new Date()) + ".txt";
                return new PrintStream(new FileOutputStream(logfile, true)){
                    private SimpleDateFormat hourFormatter = new SimpleDateFormat("HH:mm:ss");

                    public void println(String s) {
                        s = this.hourFormatter.format(new Date()) + " " + s;
                        super.println(s);
                    }
                };
            }
            catch (Exception e) {
                Logger.println("Cannot initialize log stream. " + e);
            }
        }
        return null;
    }
}

